<?php
// bootstrap.php

// اطمینان از اینکه کد فقط از طریق HTTP POST فراخوانی شود
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Method Not Allowed');
}

// اطمینان از وجود فایل‌های تنظیمات
if (!file_exists(__DIR__ . '/config.php')) {
    die('config.php not found');
}
require_once __DIR__ . '/config.php';

// --- اضافه کردن خط زیر برای لود فایل jdf.php ---
if (!file_exists(__DIR__ . '/jdf.php')) {
    error_log("jdf.php not found in root directory.");
    // می‌توانید یک خطا نمایش دهید یا از کاربر بخواهید فایل را قرار دهد
    // die('jdf.php not found');
} else {
    require_once __DIR__ . '/jdf.php';
}
// ---

// اطمینان از وجود پوشه‌های ضروری
if (!is_dir(DATA_DIR)) {
    if (!mkdir(DATA_DIR, 0755, true)) {
        error_log("Could not create data directory: " . DATA_DIR);
        die('Server Error');
    }
}
if (!is_dir(dirname(LOG_FILE))) {
    if (!mkdir(dirname(LOG_FILE), 0755, true)) {
        error_log("Could not create logs directory: " . dirname(LOG_FILE));
        die('Server Error');
    }
}
if (!is_dir(UPLOAD_PATH)) {
    if (!mkdir(UPLOAD_PATH, 0755, true)) {
        error_log("Could not create uploads directory: " . UPLOAD_PATH);
        die('Server Error');
    }
}

// تنظیم خطاهای PHP
error_reporting(E_ALL);
ini_set('log_errors', 1);
ini_set('error_log', LOG_FILE);

// فانکشن اتو لود ساده برای کلاس‌ها
spl_autoload_register(function ($class) {
    $file = __DIR__ . '/src/' . $class . '.php';
    if (file_exists($file)) {
        require_once $file;
    }
});